import pandas as pd   
import matplotlib.pyplot as plt  
import seaborn as sns  
from decision_company import read_csv_file, create_countplot, set_current_ticks, create_figure, set_plot_xlabel, create_figure, set_plot_title, set_yaxis_label, show_plots, save_plot

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Distribution plot for credit history  
create_figure((10, 6))  
create_countplot(data=credit_customers, x='credit_history', order=credit_history_counts.index)  
set_plot_title("Credit History Distribution")  
set_plot_xlabel("Credit History")  
set_yaxis_label("Frequency")  
set_current_ticks(rotation=45)  
save_plot('./ref_result/countplot_2.png')  
show_plots()  
